<?php
namespace boru\dweb\Exceptions;

use boru\dweb\Exceptions\ContextException;

class RouteNotFound extends ContextException
{
    public function __construct($kind, $qualified, array $available = array())
    {
        parent::__construct(
            ucfirst($kind) . " route not found: " . (string)$qualified,
            array(
                'kind' => (string)$kind, // "view" or "action"
                'qualified' => (string)$qualified,
                'available_count' => count($available),
                'available_sample' => array_slice($available, 0, 25),
            ),
            0
        );
    }
}
