<?php
namespace boru\dweb\Http;

class HtmlResponse extends Response
{
    /**
     * @param string $html
     * @param int $status
     * @param array $headers
     */
    public function __construct($html = '', $status = 200, array $headers = array())
    {
        $headers['Content-Type'] = 'text/html; charset=UTF-8';
        parent::__construct($status, $headers, (string)$html);
    }

    public static function ok($html, $status = 200, array $headers = array())
    {
        return new self($html, $status, $headers);
    }
}
