<?php
namespace boru\dweb\Middleware;

use boru\dweb\Contracts\MiddlewareInterface;
use boru\dweb\Http\Request;

class MethodOverrideMiddleware implements MiddlewareInterface
{
    public function handle(Request $req, $next)
    {
        if ($req->method() !== 'POST') {
            return $next($req);
        }

        $override = (string)$req->header('x-http-method-override', '');
        if ($override === '') {
            $override = (string)$req->post('_method', '');
        }

        $override = strtoupper(trim($override));
        if ($override !== '' && $this->isAllowed($override)) {
            $req = $req->withMethod($override);
        }

        return $next($req);
    }

    private function isAllowed($method)
    {
        // Common form override targets
        return in_array($method, array('PUT', 'PATCH', 'DELETE'), true);
    }
}
