<?php
namespace boru\dweb\Modules\Skeleton\Smoke;

use boru\dweb\Smoke\SmokeTestInterface;
use boru\dweb\Smoke\SmokeContext;
use boru\dweb\Smoke\RequestFactory;
use boru\dweb\Smoke\Assert;

class HomeViewTest implements SmokeTestInterface
{
    public function name() { return 'GET /?view=Skeleton.home renders HTML'; }

    public function run(SmokeContext $ctx)
    {
        $req = RequestFactory::make('/?view=Skeleton.home', 'GET');
        $resp = $ctx->dispatch($req);

        Assert::equals(200, $resp->status(), 'Expected 200');
        $body = $resp->body();

        Assert::contains('Skeleton', $body, 'Expected Skeleton content in HTML');
    }
}
