<?php
namespace boru\dweb\Rendering;

/**
 * Explicit section/slot storage for layout composition.
 *
 * - No output buffering.
 * - No magic capture.
 * - Views/services explicitly set/append strings.
 * - Layout renders sections via $sections (array or helper methods).
 */
class SectionBag
{
    /** @var array<string,string> */
    private $sections = array();

    /**
     * Replace a section's content.
     * @param string $name
     * @param string $html
     * @return void
     */
    public function set($name, $html)
    {
        $this->sections[(string)$name] = (string)$html;
    }

    /**
     * Append content to a section (concatenates).
     * @param string $name
     * @param string $html
     * @return void
     */
    public function append($name, $html)
    {
        $name = (string)$name;
        $html = (string)$html;

        if (!isset($this->sections[$name])) {
            $this->sections[$name] = $html;
            return;
        }

        $this->sections[$name] .= $html;
    }

    /**
     * Get section HTML or default.
     * @param string $name
     * @param string $default
     * @return string
     */
    public function get($name, $default = '')
    {
        $name = (string)$name;
        return isset($this->sections[$name]) ? $this->sections[$name] : (string)$default;
    }

    /**
     * @param string $name
     * @return bool
     */
    public function has($name)
    {
        return isset($this->sections[(string)$name]);
    }

    /**
     * Export as array for templates (Smarty friendly).
     * @return array
     */
    public function all()
    {
        return $this->sections;
    }

    /**
     * Convenience: ensure a section exists (sets default if missing).
     * @param string $name
     * @param string $defaultHtml
     * @return void
     */
    public function ensure($name, $defaultHtml = '')
    {
        $name = (string)$name;
        if (!isset($this->sections[$name])) {
            $this->sections[$name] = (string)$defaultHtml;
        }
    }
}
