<?php
namespace boru\dweb\Rendering;

/**
 * Convention-based section selector helper.
 *
 * Default convention:
 *   section "sidebar" => "#section-sidebar"
 *
 * Keep this tiny + explicit; no runtime detection.
 */
final class SectionSelector
{
    /** @var string */
    private $prefix;

    public function __construct($prefix = '#section-')
    {
        $this->prefix = (string)$prefix;
    }

    /**
     * @param string $sectionName
     * @return string
     */
    public function selector($sectionName)
    {
        return $this->prefix . (string)$sectionName;
    }
}
