<?php
namespace boru\dweb\Smoke;

class Assert
{
    public static function true($cond, $msg = 'Expected condition to be true')
    {
        if (!$cond) {
            throw new \RuntimeException($msg);
        }
    }

    public static function equals($expected, $actual, $msg = null)
    {
        if ($expected !== $actual) {
            if ($msg === null) {
                $msg = "Expected [" . self::dump($expected) . "] got [" . self::dump($actual) . "]";
            }
            throw new \RuntimeException($msg);
        }
    }

    public static function contains($needle, $haystack, $msg = null)
    {
        $haystack = (string)$haystack;
        $needle = (string)$needle;
        if (strpos($haystack, $needle) === false) {
            if ($msg === null) {
                $msg = "Expected output to contain: " . $needle;
            }
            throw new \RuntimeException($msg);
        }
    }

    private static function dump($v)
    {
        if (is_scalar($v) || $v === null) return var_export($v, true);
        return gettype($v);
    }
}
