<?php
namespace boru\dweb\Smoke;

class SmokeSuiteRegistry
{
    /** @var SmokeSuiteInterface[] keyed by suite name */
    private $suites = array();

    public function add(SmokeSuiteInterface $suite)
    {
        $this->suites[strtolower($suite->name())] = $suite;
        return $this;
    }

    /** @return SmokeSuiteInterface[] */
    public function all()
    {
        return $this->suites;
    }

    /** @return SmokeSuiteInterface|null */
    public function get($name)
    {
        $key = strtolower((string)$name);
        return isset($this->suites[$key]) ? $this->suites[$key] : null;
    }
}
