<?php
namespace boru\dweb\Smoke\Tests;

use boru\dweb\Smoke\SmokeTestInterface;
use boru\dweb\Smoke\SmokeContext;
use boru\dweb\Smoke\RequestFactory;
use boru\dweb\Smoke\Assert;

class RoutesDumpTest implements SmokeTestInterface
{
    public function name() { return 'GET /__dweb/routes returns JSON'; }

    public function run(SmokeContext $ctx)
    {
        $req = RequestFactory::make('/__dweb/routes', 'GET');
        $resp = $ctx->dispatch($req);

        Assert::true(method_exists($resp, 'status'), 'Response missing status()');
        Assert::equals(200, $resp->status(), 'Expected 200 from routes endpoint');

        $body = method_exists($resp, 'body') ? $resp->body() : '';
        Assert::contains('{', $body, 'Expected JSON-like body');
    }
}
