<?php
namespace boru\dweb\Cli\Commands;

use boru\dweb\Cli\CommandInterface;
use boru\dweb\Cli\App;

class HelpCommand implements CommandInterface
{
    /** @var App */
    private $app;

    public function __construct(App $app)
    {
        $this->app = $app;
    }

    public function name() { return 'help'; }

    public function description() { return 'Show help for CLI commands.'; }

    public function execute(array $args)
    {
        echo "dweb CLI\n\n";
        echo "Global options (apply to all commands except help):\n";
        echo "  --env-bootstrap=/path/to/env.php        Required. Must return KernelEnv.\n";
        echo "  --setEnv=KEY=VALUE                      Repeatable. Overrides config keys.\n\n";

        echo "Commands:\n";
        foreach ($this->app->listCommands() as $c) {
            echo "  " . $c->name() . "  -  " . $c->description() . "\n";
        }

        echo "\nExamples:\n";
        echo "  dweb smoketest --env-bootstrap=./dweb.env.php --setEnv=dweb.debug=1 --suite=all\n";
        echo "  dweb publish   --env-bootstrap=./dweb.env.php --public-assets=/var/www/app/public/assets\n";

        return 0;
    }
}
