<?php
namespace boru\dweb\Exceptions;

class ServiceBuildException extends \RuntimeException
{
    /** @var string */
    private $serviceId;

    /** @var string|null */
    private $serviceLabel;

    public function __construct($serviceId, $serviceLabel, \Exception $previous)
    {
        $this->serviceId = (string)$serviceId;
        $this->serviceLabel = $serviceLabel !== null ? (string)$serviceLabel : null;

        $name = $this->serviceLabel ? $this->serviceLabel : $this->serviceId;
        parent::__construct("Failed while building service: " . $name, 0, $previous);
    }

    public function serviceId()
    {
        return $this->serviceId;
    }

    public function serviceLabel()
    {
        return $this->serviceLabel;
    }
}
