<?php
namespace boru\dweb\Http;

class JsonResponse extends Response
{
    /**
     * @param array $data
     * @param int $status
     * @param array $headers
     */
    public function __construct(array $data = array(), $status = 200, array $headers = array())
    {
        $headers['Content-Type'] = 'application/json';
        // Let Response handle JSON encoding when $body is array
        parent::__construct($status, $headers, $data);
    }

    public static function ok(array $data, $status = 200)
    {
        return new self($data, $status);
    }

    public static function success($data, $status = 200)
    {
        return self::ok(array('success' => true, 'data' => $data), $status);
    }

    public static function error($data, $message = '', $status = 400)
    {
        $payload = array('success' => false, 'data' => $data);
        if ($message) $payload['error'] = $message;
        return self::ok($payload, $status);
    }
}
