<?php
namespace boru\dweb\Logging;

use boru\dweb\Contracts\LoggerInterface;

class ErrorLogLogger implements LoggerInterface
{
    /** @var string */
    private $prefix;

    public function __construct($prefix = 'dweb')
    {
        $this->prefix = (string)$prefix;
    }

    public function debug($message, array $context = array()) { $this->write('DEBUG', $message, $context); }
    public function info($message, array $context = array()) { $this->write('INFO', $message, $context); }
    public function warning($message, array $context = array()) { $this->write('WARN', $message, $context); }
    public function error($message, array $context = array()) { $this->write('ERROR', $message, $context); }

    private function write($level, $message, array $context)
    {
        $line = '[' . $this->prefix . '][' . $level . '] ' . (string)$message;
        if (!empty($context)) {
            $line .= ' ' . json_encode($context);
        }
        error_log($line);
    }
}
