<?php
/**
 * Defines boru\dweb\Rendering\DWebSmarty extending whichever Smarty base is available.
 *
 * Supports:
 *  - legacy global: \Smarty
 *  - composer: \Smarty\Smarty (namespaced)
 */

namespace boru\dweb\Rendering;

if (class_exists(__NAMESPACE__ . '\\DWebSmarty', false)) {
    return;
}

// Prefer legacy global \Smarty if present
if (\class_exists('\\Smarty', true)) {
    class DWebSmarty extends \Smarty {}
    return;
}

// Otherwise support composer namespaced Smarty\Smarty
if (\class_exists('\\Smarty\\Smarty', true)) {
    class DWebSmarty extends \Smarty\Smarty {}
    return;
}

throw new \RuntimeException(
    'Smarty not found. Install smarty/smarty or provide a global \\Smarty class.'
);
