<?php
namespace boru\dweb\Smoke;

class SmokeRunner
{
    /** @var SmokeTestInterface[] */
    private $tests = array();

    public function add(SmokeTestInterface $t)
    {
        $this->tests[] = $t;
        return $this;
    }

    /**
     * @param SmokeContext $ctx
     * @param string|null $filter Substring match on test name
     * @return SmokeResult
     */
    public function runAll(SmokeContext $ctx, $filter = null)
    {
        $res = new SmokeResult();
        $filter = ($filter === null || $filter === '') ? null : (string)$filter;

        foreach ($this->tests as $t) {
            $name = $t->name();

            if ($filter !== null && stripos($name, $filter) === false) {
                continue;
            }

            $res->started++;

            try {
                $t->run($ctx);
                $res->passed++;
                $res->lines[] = "[PASS] " . $name;
            } catch (\Exception $e) {
                $res->failed++;
                $res->lines[] = "[FAIL] " . $name . " — " . get_class($e) . ": " . $e->getMessage();
            }
        }

        return $res;
    }
}
