<?php
require __DIR__ . '/../vendor/autoload.php';

ini_set('display_errors', '1');
error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED);

use boru\dweb\Config\ConfigKeys;
use boru\dweb\DwebConfig;
use boru\dweb\WebUI;

// Middleware
use boru\dweb\Middleware\JsonBodyMiddleware;
use boru\dweb\Middleware\SecurityHeadersMiddleware;

// Modules
use boru\dweb\Modules\Skeleton\SkeletonModule;

/*
|--------------------------------------------------------------------------
| Configuration
|--------------------------------------------------------------------------
*/
$config = DwebConfig::createDefault();

$config->set(ConfigKeys::DEBUG_ENABLED, true);
$config->set(ConfigKeys::ERRORS_SHOW_TRACE, true);

// Defaults
$config->set(ConfigKeys::DEFAULT_MODULE, 'Skeleton');
$config->set(ConfigKeys::DEFAULT_VIEW, 'home');

// Assets (host-controlled)
$config->set(ConfigKeys::ASSET_PUBLISH_ENABLED, true);
$config->set(ConfigKeys::ASSET_PUBLIC_DIR, __DIR__ . '/assets');
$config->set(ConfigKeys::ASSET_URL_PREFIX, '/framework/assets');

/*
|--------------------------------------------------------------------------
| WebUI
|--------------------------------------------------------------------------
*/
$ui = new WebUI($config);

// Middleware order matters (outer → inner)
$ui->withMiddleware(new JsonBodyMiddleware());
$ui->withMiddleware(new SecurityHeadersMiddleware($config));

// Modules
$ui->withModule(new SkeletonModule());

/*
|--------------------------------------------------------------------------
| Run
|--------------------------------------------------------------------------
*/
$ui->render();
