<?php
namespace boru\dweb\Cli;

class CommandRegistry
{
    /** @var CommandInterface[] keyed by name */
    private $commands = array();

    public function add(CommandInterface $cmd)
    {
        $name = strtolower($cmd->name());
        $this->commands[$name] = $cmd;
        return $this;
    }

    /** @return CommandInterface|null */
    public function get($name)
    {
        $key = strtolower((string)$name);
        return isset($this->commands[$key]) ? $this->commands[$key] : null;
    }

    /** @return CommandInterface[] */
    public function all()
    {
        return $this->commands;
    }
}
