<?php
namespace boru\dweb\Config;

final class ConfigKeys
{
    // Debug
    const DEBUG_ENABLED = 'dweb.debug.enabled';
    const ERRORS_SHOW_TRACE = 'dweb.errors.show_trace';
    const DEBUG_ROUTES_ENABLED = 'dweb.debug.routes.enabled';
    const DEBUG_ROUTES_PATH = 'dweb.debug.routes.path';
    const ERRORS_SANITIZE_USER_MESSAGES = 'dweb.errors.sanitize_user_messages';
    const ERRORS_SANITIZE_DEBUG_DETAILS = 'dweb.errors.sanitize_debug_details';

    // URLs
    const URLS_CANONICAL_ENABLED = 'dweb.urls.canonical.enabled';
    const BASE_PATH = 'dweb.base_path';

    // Rendering / Smarty
    const RENDERER_ENGINE = 'dweb.render.engine'; // e.g. "smarty"
    const SMARTY_COMPILE_DIR = 'dweb.smarty.compile_dir';
    const SMARTY_CACHE_DIR = 'dweb.smarty.cache_dir';
    const SMARTY_FORCE_COMPILE = 'dweb.smarty.force_compile';
    const SMARTY_COMPILE_CHECK = 'dweb.smarty.compile_check';
    const SMARTY_CACHING = 'dweb.smarty.caching';
    const SMARTY_CACHE_LIFETIME = 'dweb.smarty.cache_lifetime';

    // Logging
    const LOGGER_CLASS = 'dweb.logger.class'; // optional, if you want config-driven logger selection

    // General Web UI Settings
    const TEMPLATES_PATH = 'dweb.templates.path';
    const PUBLIC_DIR = 'dweb.public_dir';
    const PAGE_PARAM = 'dweb.page_param';
    const ACTION_PARAM = 'dweb.action_param';
    const DEFAULT_MODULE = 'dweb.default_module';
    const DEFAULT_VIEW = 'dweb.default_view';

    // Security Headers (Middleware)
    const SECURITY_HEADERS_ENABLED = 'dweb.security.headers.enabled';
    const SECURITY_HEADERS_CONTENT_SECURITY_POLICY = 'dweb.security.headers.content_security_policy';
    const SECURITY_HEADERS_X_FRAME_OPTIONS = 'dweb.security.headers.x_frame_options';
    const SECURITY_HEADERS_X_CONTENT_TYPE_OPTIONS = 'dweb.security.headers.x_content_type_options';
    const SECURITY_HEADERS_X_XSS_PROTECTION = 'dweb.security.headers.x_xss_protection';

    // Publishing
    const ASSET_PUBLISH_ENABLED = 'dweb.assets.publish.enabled';
    const ASSET_PUBLIC_DIR      = 'dweb.assets.public_dir';    // filesystem path (absolute recommended)
    const ASSET_URL_PREFIX      = 'dweb.assets.url_prefix';    // url prefix (you likely already have this)
    const ASSET_VERSION         = 'dweb.assets.version';       // optional

    // CLI invocation (optional layer)
    const CLI_ENABLED       = 'dweb.cli.enabled';        // bool, default true
    const CLI_BIN_PATH      = 'dweb.cli.bin_path';       // string, default "vendor/bin/dweb"
    const CLI_CWD           = 'dweb.cli.cwd';            // string|null, default project root (best effort)
    const CLI_ENV_BOOTSTRAP = 'dweb.cli.env_bootstrap';  // string|null, optional path to env bootstrap file
    const CLI_TIMEOUT_SEC   = 'dweb.cli.timeout_sec';    // int|null, optional
}
