<?php
namespace boru\dweb\Contracts;

use boru\dweb\Cli\CliResult;

interface CliInvokerInterface
{
    /**
     * Invoke a registered dweb CLI command.
     *
     * @param string $command e.g. "publish", "smoketest", "boruai:stream"
     * @param array $args positional args (each becomes its own argv token)
     * @param array $options assoc options => value. Produces:
     *   - bool true  => --key
     *   - bool false => omitted
     *   - null       => omitted
     *   - other      => --key=value
     *
     * @return CliResult
     */
    public function run($command, array $args = array(), array $options = array());
}
