<?php
namespace boru\dweb\Domain;

use boru\query\Query;

class BoruAiUserIdentity extends UserIdentity
{
    /** @var User[] */
    private static $userCache = [];
    
    /** @var \boru\dhdb\core\Row */
    private $userRow;

    /**
     * @param int|string $id
     * @param string $name
     * @param object $boruAiUser  Instance returned by \boru\boruai\UI\User::login()
     */
    public function __construct($id=null, $name=null)
    {
        if(is_numeric($id)) {
            $this->setById($id);
            return;
        } elseif(is_string($id)) {
            $this->setByName($id);
            return;
        } else {
            if($name!==null) {
                $this->setByName($name);
            }
        }
    }

    private function setById($id,$force=false) {
        if(isset(static::$userCache[$id]) && !$force) {
            return $this->fromCache($id);
        }
        $query = Query::create()->select("id")->from("vtiger_users")->where("id", "=", $id);
        foreach($query->toRows() as $row) {
            $this->setFromRow($row);
            break;
        }
    }
    private function setByName($name) {
        $query = Query::create()->select("id")->from("vtiger_users")->where("user_name", "=", $name);
        foreach($query->toRows() as $row) {
            $this->setFromRow($row);
            break;
        }
    }

    private function fromCache($id) {
        if(isset(static::$userCache[$id])) {
            $cachedUser = static::$userCache[$id];
            $this->id($cachedUser->id());
            $this->name($cachedUser->name());
            $this->userRow = $cachedUser->userRow;
            return true;
        }
        return false;
    }

    private function setFromRow($row) {
        if($row) {
            $this->id($row["id"]);
            if(isset($row["user_name"])) {
                $this->name($row["user_name"]);
            } elseif(isset($row["username"])) {
                $this->name($row["username"]);
            } elseif(isset($row["name"])) {
                $this->name($row["name"]);
            } else {
                $this->name($row["id"]);
            }
            $this->userRow = $row;
            static::$userCache[$this->id()] = $this;
        }
    }
}
