<?php
namespace boru\dweb\Http;

class SseEvent
{
    /** @var string|null */
    public $event;

    /** @var string|null */
    public $id;

    /** @var int|null milliseconds */
    public $retry;

    /** @var string */
    public $data;

    public function __construct($data, $event = null, $id = null, $retry = null)
    {
        $this->data  = self::normalizeData($data);
        $this->event = $event !== null ? (string)$event : null;
        $this->id    = $id !== null ? (string)$id : null;
        $this->retry = $retry !== null ? (int)$retry : null;
    }

    /**
     * @param mixed $data
     * @return string
     */
    public static function normalizeData($data)
    {
        // arrays/objects => JSON
        if (is_array($data) || is_object($data)) {
            $json = json_encode($data);
            if ($json !== false) return $json;
        }
        return (string)$data;
    }

    /**
     * Render to SSE wire format.
     * Each line in data must be prefixed with "data: ".
     *
     * @return string
     */
    public function toWire()
    {
        $out = '';

        if ($this->id !== null) {
            $out .= 'id: ' . $this->id . "\n";
        }
        if ($this->event !== null) {
            $out .= 'event: ' . $this->event . "\n";
        }
        if ($this->retry !== null) {
            $out .= 'retry: ' . (int)$this->retry . "\n";
        }

        $lines = preg_split("/\\r\\n|\\r|\\n/", $this->data);
        foreach ($lines as $line) {
            $out .= 'data: ' . $line . "\n";
        }

        $out .= "\n";
        return $out;
    }
}
