<?php
namespace boru\dweb\Modules\Skeleton\Smoke;

use boru\dweb\Smoke\SmokeTestInterface;
use boru\dweb\Smoke\SmokeContext;
use boru\dweb\Smoke\RequestFactory;
use boru\dweb\Smoke\Assert;

class ContextViewTest implements SmokeTestInterface
{
    public function name() { return 'GET /Skeleton/contextDemo renders HTML'; }

    public function run(SmokeContext $ctx)
    {
        $req = RequestFactory::make('/Skeleton/contextDemo', 'GET');
        $resp = $ctx->dispatch($req);

        Assert::equals(200, $resp->status(), 'Expected 200');
        $body = $resp->body();

        Assert::contains('Skeleton', $body, 'Expected Skeleton content in HTML');
    }
}
