<h1>{$title|escape}</h1>

<p>
  This page proves <b>ControllerContext</b> injection into Views and Actions.
</p>

<ul>
  <li><b>Debug enabled:</b> {if $debug}yes{else}no{/if}</li>
  <li><b>CLI available:</b> {if $hasCli}yes{else}no{/if}</li>
  <li><b>Assets available:</b> {if $hasAssets}yes{else}no{/if}</li>
</ul>

<hr>

<h3>URLs generated by controller via <code>$this->dweb()</code></h3>
<ul>
  <li><a href="{$urls.home|escape}">Home</a> <code>{$urls.home|escape}</code></li>
  <li><a href="{$urls['ctx demo']|escape}">Context Demo</a> <code>{$urls['ctx demo']|escape}</code></li>
</ul>

<hr>

<h3>Action response via <code>$this->dweb()->action()</code></h3>

<p>
  <a href="{$urls['ctx json']|escape}">Open JSON: contextInfo</a>
  <br>
  <code>{$urls['ctx json']|escape}</code>
</p>

<button
  hx-get="{$urls['ctx json']|escape}"
  hx-target="#ctx-json"
  hx-swap="innerHTML">
  Load JSON into page
</button>

<pre id="ctx-json" style="margin-top: 10px; padding: 10px; border: 1px solid #ddd;">
(click button)
</pre>
