{* src/Modules/Skeleton/templates/layouts/default.tpl *}
<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{$title|default:'Skeleton Module'|escape}</title>

    {* Bootstrap CSS *}
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    {$dweb->section('head')}
</head>

<body class="bg-light">
    <style>
        .sse-demo {
            margin-top: 12px;
        }

        .sse-status {
            margin-bottom: 10px;
        }

        .sse-status-inner {
            padding: 8px 10px;
            border: 1px solid #ddd;
            border-radius: 6px;
        }

        .sse-status-connected {
            background: #f6fffb;
        }

        .sse-status-done {
            background: #f7f7f7;
        }

        .sse-stream {
            border: 1px solid #ddd;
            border-radius: 6px;
            padding: 10px;
            min-height: 120px;
        }

        .sse-hint {
            opacity: 0.7;
            font-style: italic;
        }

        .sse-chunk {
            padding: 6px 0;
            border-bottom: 1px dashed #eee;
        }

        .sse-chunk:last-child {
            border-bottom: none;
        }

        .sse-chunk-num {
            display: inline-block;
            width: 42px;
            font-weight: bold;
        }

        .sse-chunk-ts {
            display: inline-block;
            width: 78px;
            opacity: 0.7;
        }
    </style>
    <header id="{$dweb->sectionId('header')}" data-dweb-section="header">
        {$sections.header|default:'' nofilter}
    </header>

    <div class="container-fluid">
        <div class="row g-0">
            <aside id="{$dweb->sectionId('sidebar')}" data-dweb-section="sidebar"
                class="col-12 col-md-3 col-lg-2 border-end bg-white min-vh-100">
                {$sections.sidebar|default:'' nofilter}
            </aside>

            <main id="{$dweb->sectionId('content')}" data-dweb-section="content"
                class="col-12 col-md-9 col-lg-10 p-3 p-md-4">
                {$sections.content|default:$content nofilter}
            </main>
        </div>
    </div>

    <footer id="{$dweb->sectionId('footer')}" data-dweb-section="footer" class="border-top bg-white">
        {$sections.footer|default:'' nofilter}
    </footer>

    {$dweb->section('scripts')}

    {* Bootstrap JS bundle (includes Popper) *}
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    {* htmx *}
    <script src="https://unpkg.com/htmx.org@1.9.12"></script>
    <script src="https://unpkg.com/htmx.org/dist/ext/sse.js"></script>
</body>

</html>