<?php
namespace boru\dweb\Mvc;

use boru\dweb\Routing\CanonicalUrl;

class DwebHelper
{
    /** @var CanonicalUrl */
    private $canonical;

    /** @var string */
    private $moduleName;

    public function __construct(CanonicalUrl $canonical, $moduleName)
    {
        $this->canonical  = $canonical;
        $this->moduleName = (string)$moduleName;
    }

    public function module()
    {
        return $this->moduleName;
    }

    public function view($viewName, $tail = null)
    {
        $qualified = $this->canonical->qualifyView($this->moduleName, (string)$viewName);
        return $this->canonical->view($qualified, $tail);
    }

    public function action($actionName, $tail = null)
    {
        $qualified = $this->canonical->qualifyAction($this->moduleName, (string)$actionName);
        return $this->canonical->action($qualified, $tail);
    }

    public function mView($moduleName, $viewName, $tail = null)
    {
        $qualified = $this->canonical->qualifyView((string)$moduleName, (string)$viewName);
        return $this->canonical->view($qualified, $tail);
    }

    public function mAction($moduleName, $actionName, $tail = null)
    {
        $qualified = $this->canonical->qualifyAction((string)$moduleName, (string)$actionName);
        return $this->canonical->action($qualified, $tail);
    }

    // keep the convention consistent with templates
    public function sectionId($sectionName)
    {
        return 'section-' . (string)$sectionName;
    }

    public function sectionSelector($sectionName)
    {
        return '#section-' . (string)$sectionName;
    }
}
