<?php
namespace boru\dweb\Routing;

use boru\dweb\Kernel\ModuleManager;

class ModuleActionHandler
{
    /** @var string */
    private $module;

    /** @var string */
    private $action;

    /** @var \boru\dweb\Kernel\Container */
    private $container;

    public function __construct($module, $action, $container)
    {
        $this->module = (string)$module;
        $this->action = (string)$action;
        $this->container = $container;
    }

    public function __invoke($req)
    {
        /** @var \boru\dweb\Kernel\ModuleManager $mm */
        $mm = $this->container->get(\boru\dweb\Kernel\ModuleManager::class);

        $af = $mm->getActionFactory($this->module, $this->container);
        return $af->make($this->action)->handle($req);
    }
}
