<?php
namespace boru\dweb\Routing;

class RouteCollection
{
    /** @var array<string, array> */
    private $actions = array();

    /** @var array<string, array> */
    private $views = array();

    /**
     * @param string $name qualified name: "Module.action"
     * @param callable $handler
     * @param array|string|null $methods
     * @param array|null $pathParams ordered param names: ['id','slug']
     * @return $this
     */
    public function addAction($name, $handler, $methods = null, $pathParams = null)
    {
        $name = (string)$name;

        $m = null;
        if ($methods !== null) {
            if (!is_array($methods)) $methods = array($methods);
            $m = array();
            foreach ($methods as $mm) {
                $mm = strtoupper((string)$mm);
                if ($mm !== '') $m[$mm] = true;
            }
        }

        $pp = null;
        if (is_array($pathParams)) {
            $pp = array();
            foreach ($pathParams as $p) {
                $p = trim((string)$p);
                if ($p !== '') $pp[] = $p;
            }
            if (count($pp) === 0) $pp = null;
        }

        $this->actions[$name] = array(
            'handler'     => $handler,
            'methods'     => $m,   // null means "any"
            'pathParams'  => $pp,  // null means "no named params"
        );

        return $this;
    }

    /**
     * @param string $name qualified name: "Module.view"
     * @param callable $handler
     * @param array|null $pathParams ordered param names: ['id','slug']
     * @return $this
     */
    public function addView($name, $handler, $pathParams = null)
    {
        $name = (string)$name;

        $pp = null;
        if (is_array($pathParams)) {
            $pp = array();
            foreach ($pathParams as $p) {
                $p = trim((string)$p);
                if ($p !== '') $pp[] = $p;
            }
            if (count($pp) === 0) $pp = null;
        }

        $this->views[$name] = array(
            'handler'    => $handler,
            'pathParams' => $pp,
        );

        return $this;
    }

    public function getAction($name)
    {
        $name = (string)$name;
        return isset($this->actions[$name]) ? $this->actions[$name] : null;
    }

    /**
     * Back-compat: return callable handler (old behavior)
     */
    public function getView($name)
    {
        $rec = $this->getViewRecord($name);
        return $rec ? $rec['handler'] : null;
    }

    public function getViewRecord($name)
    {
        $key = (string)$name;
        return isset($this->views[$key]) ? $this->views[$key] : null;
    }

    public function forModule($moduleName)
    {
        return new ModuleRouteCollection($this, $moduleName);
    }

    /**
     * Back-compat: return name => callable handlers (used by RouteDump)
     * @return array<string, callable>
     */
    public function allViews()
    {
        $out = array();
        foreach ($this->views as $name => $rec) {
            $out[$name] = $rec['handler'];
        }
        return $out;
    }

    /**
     * name => ['handler'=>callable,'methods'=>array|null,'pathParams'=>array|null]
     */
    public function allActions()
    {
        return $this->actions;
    }
}
