<?php
namespace boru\dweb\Smoke;

use boru\dweb\Http\Request;

class RequestFactory
{
    /**
     * Create a Request for smoke tests.
     *
     * @param string $uri ex "/api/Skeleton/ping"
     * @param string $method GET/POST/PUT/DELETE
     * @param array $headers assoc header => value
     * @param string $rawBody
     * @param array $post
     * @param array $query
     * @return Request
     */
    public static function make($uri, $method = 'GET', array $headers = array(), $rawBody = '', array $post = array(), array $query = array())
    {
        $server = array(
            'REQUEST_URI' => $uri,
            'REQUEST_METHOD' => strtoupper($method),
        );

        return new Request(
            $query,
            $post,
            $server,
            array(),
            array(),
            $headers,
            $rawBody
        );
    }
}
