<?php
namespace boru\dweb\Support;

class BootstrapFile
{
    /**
     * @param string $path
     * @return HostBootstrap
     */
    public static function load($path)
    {
        if (!file_exists($path)) {
            throw new \RuntimeException("Bootstrap file not found: " . $path);
        }

        $obj = require $path;

        if (!$obj instanceof HostBootstrap) {
            throw new \RuntimeException("Bootstrap file must return HostBootstrap: " . $path);
        }

        return $obj;
    }
}
