<?php
namespace boru\dweb\Support;

use boru\dweb\Contracts\ControllerContextInterface;
use boru\dweb\Contracts\SettingsInterface;
use boru\dweb\Contracts\CliInvokerInterface;
use boru\dweb\Contracts\LoggerInterface;
use boru\dweb\Mvc\DwebHelper;
use boru\dweb\Assets\AssetManager;

class ControllerContext implements ControllerContextInterface
{
    /** @var SettingsInterface */
    private $settings;

    /** @var DwebHelper */
    private $dweb;

    /** @var CliInvokerInterface|null */
    private $cli;

    /** @var LoggerInterface|null */
    private $logger;

    /** @var AssetManager|null */
    private $assets;

    public function __construct(SettingsInterface $settings, DwebHelper $dweb)
    {
        $this->settings = $settings;
        $this->dweb = $dweb;
        $this->cli = null;
        $this->logger = null;
        $this->assets = null;
    }

    public function withCli(CliInvokerInterface $cli)
    {
        $this->cli = $cli;
        return $this;
    }

    public function withLogger(LoggerInterface $logger)
    {
        $this->logger = $logger;
        return $this;
    }

    public function withAssets(AssetManager $assets)
    {
        $this->assets = $assets;
        return $this;
    }

    public function dweb()
    {
        return $this->dweb;
    }

    public function cli()
    {
        return $this->cli;
    }

    public function logger()
    {
        return $this->logger;
    }

    public function settings()
    {
        return $this->settings;
    }

    public function assets()
    {
        return $this->assets;
    }
}
