<?php
namespace boru\dweb\Support;

use boru\dweb\Kernel\Container;
use boru\dweb\Kernel\ModuleManager;
use boru\dweb\DwebConfig;

class HostBootstrap
{
    /** @var array */
    private $opts = array();

    /** @var callable|null */
    private $configureContainer;

    /** @var callable|null */
    private $configureModules;

    /** @var array|null */
    private $middleware;

    public static function create()
    {
        return new self();
    }

    public function withOpts(array $opts)
    {
        foreach ($opts as $k => $v) $this->opts[$k] = $v;
        return $this;
    }

    /** function(Container $c, WebConfig $config): void */
    public function withContainer($cb)
    {
        $this->configureContainer = $cb;
        return $this;
    }

    /** function(ModuleManager $mm, Container $c, WebConfig $config): void */
    public function withModules($cb)
    {
        $this->configureModules = $cb;
        return $this;
    }

    /** @param array|callable|null $mw */
    public function withMiddleware($mw)
    {
        $this->middleware = $mw;
        return $this;
    }

    /** @return array|callable|null */
    public function middleware()
    {
        return $this->middleware;
    }


    /** @return array */
    public function opts()
    {
        return $this->opts;
    }

    /** @return callable|null */
    public function configureContainer()
    {
        return $this->configureContainer;
    }

    /** @return callable|null */
    public function configureModules()
    {
        return $this->configureModules;
    }
}
