<?php
namespace boru\dweb\Support;

use boru\dweb\DwebConfig;
use boru\dweb\Kernel\Container;

class KernelEnv
{
    /** @var DwebConfig */
    private $config;

    /** @var Container */
    private $container;

    /** @var mixed */
    private $routes;

    /** @var mixed */
    private $router;

    /** @var callable */
    private $pipeline;

    public function __construct(DwebConfig $config, Container $container, $routes, $router, $pipeline)
    {
        $this->config = $config;
        $this->container = $container;
        $this->routes = $routes;
        $this->router = $router;
        $this->pipeline = $pipeline;
    }

    /** @return DwebConfig */
    public function config() { return $this->config; }

    /** @return Container */
    public function container() { return $this->container; }

    /** @return mixed */
    public function routes() { return $this->routes; }

    /** @return mixed */
    public function router() { return $this->router; }

    /** @return callable */
    public function pipeline() { return $this->pipeline; }
}
