<?php
namespace boru\dweb\Support;

use boru\dweb\DwebConfig;
use boru\dweb\Config\ConfigKeys;

class KernelSpec
{
    /** @var DwebConfig */
    private $config;

    /** @var callable|null */
    private $configureContainer;

    /** @var callable|null */
    private $configureModules;

    /** @var array|null */
    private $middleware;

    public static function fromConfig(DwebConfig $config)
    {
        $s = new self();
        $s->config = $config;
        return $s;
    }

    public static function fromOpts(array $opts = array())
    {
        $cfg = \boru\dweb\Support\Bootstrap::config($opts);
        return self::fromConfig($cfg);
    }

    /** @return DwebConfig */
    public function config()
    {
        return $this->config;
    }

    /** function(Container $c, WebConfig $cfg): void */
    public function withContainer($cb)
    {
        $this->configureContainer = $cb;
        return $this;
    }

    /** function(ModuleManager $mm, Container $c, WebConfig $cfg): void */
    public function withModules($cb)
    {
        $this->configureModules = $cb;
        return $this;
    }

    /** @param array|null $middleware */
    public function withMiddleware(array $middleware = null)
    {
        $this->middleware = $middleware;
        return $this;
    }

    public function configureContainer() { return $this->configureContainer; }
    public function configureModules() { return $this->configureModules; }
    public function middleware() { return $this->middleware; }
}
