# boru/dweb — Overview

`boru/dweb` is a **lightweight, explicit PHP web framework** designed for
modular applications, APIs, and server-rendered UIs.

It favors:

- explicit configuration
- explicit rendering
- explicit composition
- minimal magic
- long-term maintainability

The framework is **PHP 5.6 → PHP 8 compatible** and avoids reflection,
autowiring, or runtime inference.

---

## What dweb is

- A framework, not an application
- A kernel + module system
- A router + middleware pipeline
- A rendering and response abstraction
- A CLI + web execution environment

---

## What dweb is not

- Not an ORM
- Not an MVC autoloader
- Not opinionated about frontend frameworks
- Not dependent on annotations or attributes
- Not tied to a single rendering engine

---

## Core Concepts

| Concept | Meaning |
|------|--------|
| Module | A feature bundle (routes, controllers, templates, assets, CLI hooks) |
| View | A controller intended to return HTML (full pages or fragments) |
| Action | A controller intended to return non-page responses (JSON, SSE, fragments) |
| Fragment | Layout-free HTML output |
| Section | Named layout slot populated explicitly |
| KernelEnv | A fully built runtime environment |

Views and Actions share **the same capabilities**.
The distinction is semantic, not technical.

---

## Routing Basics

At the HTTP level dweb has two primary routing modes:

- **Module Views**  
  Requests whose path does *not* start with `/api/` are routed to **views**.  
  The first path segment is always interpreted as the **module name**:

  - `/Skeleton/home` → module `Skeleton`, view `home`
  - `/Blog/post/123` → module `Blog`, view `post`, path param `123`

- **Module Actions (API)**  
  Requests under `/api/…` route to **actions**:

  - `/api/Blog/create` → module `Blog`, action `create`

By default, view routes follow the pattern:

```text
/<Module>/<View>/<tail...>
```

Modules can opt into more explicit **path patterns** on a per-route basis.  
This is described in detail in `02_module_authoring.md`.

---

## Execution Environments

dweb supports multiple entry points using the same kernel:

- Web (`public/index.php`)
- CLI (`vendor/bin/dweb`)
- Smoke tests
- Asset publishing
- Custom scripts

All environments are built from the same `KernelEnv`.

---

## Design Philosophy

- Nothing happens unless you ask for it
- No implicit filesystem conventions
- No auto-magic routing
- No hidden rendering
- No framework-owned UI

If a response is returned, it should be obvious **where it came from and why**.