(function () {
    function closestSseRoot(el) {
        var cur = el;
        while (cur && cur.getAttribute) {
            var hx = cur.getAttribute("hx-ext") || "";
            if (hx.indexOf("sse") !== -1) {
                return cur;
            }
            cur = cur.parentNode;
        }
        return null;
    }

    function closeEventSourceFrameworky(root) {
        if (!root) return false;
        if (root.getAttribute && root.getAttribute("data-dweb-sse-closed") === "1") return true;

        // Prevent future initialization
        if (root.removeAttribute) {
            root.removeAttribute("sse-connect");
        }

        // Try to close the EventSource stored by the extension
        try {
            if (window.htmx && typeof window.htmx.getInternalData === "function") {
                var data = window.htmx.getInternalData(root) || {};

                // The SSE extension has varied over time; try a few likely keys.
                var es =
                    data.sseEventSource ||
                    data.eventSource ||
                    data.source ||
                    data.sseSource ||
                    null;

                // Also scan nested objects just in case
                if (!es && data.sse && data.sse.eventSource) es = data.sse.eventSource;
                if (!es && data.sse && data.sse.source) es = data.sse.source;

                if (es && typeof es.close === "function") {
                    es.close();
                }

                // Nuke references so reconnect timers can't reuse it
                data.sseEventSource = null;
                data.eventSource = null;
                data.source = null;
                if (data.sse) {
                    data.sse.eventSource = null;
                    data.sse.source = null;
                }
            }
        } catch (e) {
            // ignore
        }

        // Mark closed so we don't repeat work
        if (root.setAttribute) root.setAttribute("data-dweb-sse-closed", "1");
        return true;
    }

    function stopReconnect(markerEl) {
        var root = closestSseRoot(markerEl);
        if (!root) return;

        // Optional: freeze to a static location first
        var freezeSel = markerEl.getAttribute("data-dweb-sse-freeze");
        if (freezeSel) {
            try {
                var out = document.querySelector(freezeSel);
                if (out) {
                    out.innerHTML = "";
                    // clone the full root (or its inner contents)
                    var cloned = root.cloneNode(true);
                    if (cloned.removeAttribute) {
                        cloned.removeAttribute("sse-connect");
                        cloned.setAttribute("data-dweb-sse-closed", "1");
                    }
                    out.appendChild(cloned);
                }
            } catch (e) { }
        }

        closeEventSourceFrameworky(root);

        // Optional: remove the SSE root entirely (strongest)
        if (markerEl.getAttribute("data-dweb-sse-remove") === "1") {
            if (root.parentNode) root.parentNode.removeChild(root);
        }
    }

    function findMarker(evt) {
        var t = evt && evt.target ? evt.target : null;
        if (!t) return null;

        if (t.getAttribute && t.getAttribute("data-dweb-sse-done") === "1") return t;
        if (t.querySelector) {
            var m = t.querySelector("[data-dweb-sse-done='1']");
            if (m) return m;
        }
        return null;
    }

    function onEvt(evt) {
        var marker = findMarker(evt);
        if (!marker) return;
        console.log("dweb-sse: done marker detected (" + evt.type + ")");
        stopReconnect(marker);
    }

    document.body.addEventListener("htmx:load", onEvt);
    document.body.addEventListener("htmx:afterSettle", onEvt);
})();
