<?php

use boru\dweb\DwebConfig;
use boru\dweb\Config\ConfigKeys;

// Host modules
use boru\dweb\Modules\Skeleton\SkeletonModule;
use boru\dweb\Modules\Realtime\RealtimeModule;

// Middleware (for web)
use boru\dweb\Middleware\JsonBodyMiddleware;
use boru\dweb\Middleware\SecurityHeadersMiddleware;

// --------------------------------------------------------------------------
// Configuration
// --------------------------------------------------------------------------

$config = DwebConfig::createDefault();

$config->set(ConfigKeys::DEBUG_ENABLED, true);
$config->set(ConfigKeys::ERRORS_SHOW_TRACE, true);
$config->set(ConfigKeys::DEBUG_ROUTES_ENABLED, true);

// Defaults
$config->set(ConfigKeys::DEFAULT_MODULE, 'Skeleton');
$config->set(ConfigKeys::DEFAULT_VIEW, 'home');

// Assets (host-controlled)
$config->set(ConfigKeys::ASSET_PUBLISH_ENABLED, true);
$config->set(ConfigKeys::ASSET_PUBLIC_DIR, __DIR__ . '/assets');
$config->set(ConfigKeys::ASSET_URL_PREFIX, '/framework/assets');

// Sockets
$config->set(ConfigKeys::SOCKET_ENABLED, true);
$config->set(ConfigKeys::SOCKET_NODE_PORT, 6001);
$config->set(ConfigKeys::SOCKET_JWT_SECRET, 'supersecretkey');
$config->set(ConfigKeys::SOCKET_API_SECRET, 'apisecretvalue');

// --------------------------------------------------------------------------
// Host modules
// --------------------------------------------------------------------------

$modules = array(
    new SkeletonModule(),
    new RealtimeModule(),
);

// --------------------------------------------------------------------------
// Optional container bootstrap
// --------------------------------------------------------------------------

$containerBootstrap = function ($c, $cfg) {
    // host service bindings go here
};

// --------------------------------------------------------------------------
// Optional web middleware defaults
// --------------------------------------------------------------------------

$webMiddleware = array(
    new JsonBodyMiddleware(),
    new SecurityHeadersMiddleware($config),
);

// Return a simple struct that the framework will consume.
return array(
    'config'         => $config,
    'modules'        => $modules,
    'container'      => $containerBootstrap,
    'web_middleware' => $webMiddleware,
);
