<?php
namespace boru\dweb\Cli;

use boru\dweb\Contracts\ControllerAwareCommandInterface;
use boru\dweb\Contracts\ControllerContextInterface;

class CommandRegistry
{
    /** @var CommandInterface[] keyed by name */
    private $commands = array();

    public function add(CommandInterface $cmd)
    {
        $name = strtolower($cmd->name());
        $this->commands[$name] = $cmd;
        return $this;
    }

    /** @return CommandInterface|null */
    public function get($name)
    {
        $key = strtolower((string)$name);
        return isset($this->commands[$key]) ? $this->commands[$key] : null;
    }

    /** @return CommandInterface[] */
    public function all()
    {
        return $this->commands;
    }

    /**
     * Inject a ControllerContext into any commands that opt in.
     *
     * @param ControllerContextInterface $ctx
     * @return $this
     */
    public function withControllerContext(ControllerContextInterface $ctx)
    {
        foreach ($this->commands as $command) {
            if ($command instanceof ControllerAwareCommandInterface) {
                $command->setControllerContext($ctx);
            }
        }
        return $this;
    }
}
