<?php
namespace boru\dweb\Cli\Commands;

use boru\dweb\Cli\CommandInterface;
use boru\dweb\Cli\App;

class HelpCommand implements CommandInterface
{
    /** @var App */
    private $app;

    public function __construct(App $app)
    {
        $this->app = $app;
    }

    public function name() { return 'help'; }

    public function description() { return 'Show help for CLI commands.'; }

    public function execute(array $args)
    {
        echo "dweb CLI\n\n";

        echo "Global options (may appear anywhere in argv):\n";
        echo "  -e, --env=/path/to/env.php             Env bootstrap file. Must return KernelEnv.\n";
        echo "      --env-bootstrap=/path/to/env.php   Alias for --env (legacy).\n";
        echo "      --setEnv=KEY=VALUE                 Repeatable. Overrides config keys.\n\n";

        echo "Notes:\n";
        echo "  - The CLI loads the environment BEFORE resolving commands.\n";
        echo "    This allows modules to register CLI commands.\n";
        echo "  - If you pass -e/--env, help will also include module-provided commands.\n\n";

        echo "Commands:\n";
        foreach ($this->app->listCommands() as $c) {
            echo "  " . $c->name() . "  -  " . $c->description() . "\n";
        }

        echo "\nExamples:\n";
        echo "  dweb -e ./dweb.env.php smoketest --setEnv=dweb.debug=1 --suite=all\n";
        echo "  dweb --env=./dweb.env.php publish --public-assets=/var/www/app/public/assets\n";
        echo "  dweb smoketest --env-bootstrap=./dweb.env.php --suite=skeleton\n";

        return 0;
    }
}
