<?php
namespace boru\dweb\Cli\Commands;

use boru\dweb\Cli\CommandInterface;

class SleepCommand implements CommandInterface
{
    public function name() { return 'sleep'; }

    public function description() { return 'Sleep for N seconds (for testing detached execution).'; }

    public function execute(array $args)
    {
        file_put_contents("/var/work/libs/framework/sleep_command.log", "SleepCommand execute args: " . json_encode($args) . "\n", FILE_APPEND);
        $sec = 2;
        if (isset($args[0]) && is_numeric($args[0])) {
            $sec = (int)$args[0];
        }
        if ($sec < 0) $sec = 0;
        sleep($sec);
        echo "slept={$sec}\n";
        file_put_contents("/var/work/libs/framework/sleep_command.log", "Slept {$sec} seconds\n", FILE_APPEND);
        return 0;
    }
}
