<?php
namespace boru\dweb\Cli;

use boru\dweb\Contracts\ControllerContextInterface;

trait ControllerContextAwareTrait
{
    /** @var ControllerContextInterface|null */
    private $controllerContext;

    public function setControllerContext(ControllerContextInterface $ctx)
    {
        $this->controllerContext = $ctx;
    }

    /**
     * @return ControllerContextInterface
     */
    protected function ctx()
    {
        if (!$this->controllerContext) {
            throw new \RuntimeException('ControllerContext not injected into CLI command: ' . get_class($this));
        }
        return $this->controllerContext;
    }
}
