<?php
namespace boru\dweb\Contracts;

use boru\dweb\Routing\DwebHelper;
use boru\dweb\Support\SocketTokenService;
use boru\dweb\Support\SocketPublisher;

interface ControllerContextInterface
{
    /** @return DwebHelper */
    public function dweb();

    /** @return CliInvokerInterface|null */
    public function cli();

    /** @return LoggerInterface|null */
    public function logger();

    /** @return SettingsInterface */
    public function settings();

    /** @return object|null Asset manager if present */
    public function assets();

    /** @return SocketTokenService|null Socket token service if present */
    public function socketTokenService();

    /** @return SocketPublisher|null Socket publisher if present */
    public function socketPublisher();

    /** @return object|null User identity if set */
    public function userIdentity();

    /**
     * Forward to another view within the same request lifecycle.
     *
     * @param string $qualifiedView e.g. "Module.View"
     * @param \boru\dweb\Http\Request|null $req Optional request override
     * @return object Response (typically HtmlResponse)
     */
    public function dispatchView($qualifiedView, \boru\dweb\Http\Request $req = null);

    /**
     * Forward to another action within the same request lifecycle.
     *
     * @param string $qualifiedAction e.g. "Module.Action"
     * @param \boru\dweb\Http\Request|null $req Optional request override
     * @return object Response (typically JsonResponse or HtmlResponse)
     */
    public function dispatchAction($qualifiedAction, \boru\dweb\Http\Request $req = null);
}
