<?php
namespace boru\dweb\Contracts;

interface LayoutRegistryInterface
{
    /**
     * Register a layout by name.
     *
     * @param string $name       e.g. "default" or "Skeleton:demo"
     * @param string $moduleName e.g. "core", "Skeleton"
     * @param string $layoutId   e.g. "layouts/default"
     * @return void
     */
    public function register($name, $moduleName, $layoutId);

    /**
     * Resolve a layout name to a (module, layoutId) pair.
     *
     * @param string $name
     * @return array|null  ['module' => string, 'layout' => string] or null if missing
     */
    public function get($name);

    /**
     * Set the *effective* default layout name.
     *
     * Example: "Core:default" or "App:default".
     *
     * @param string $name
     * @return void
     */
    public function setDefaultName($name);

    /**
     * Get the effective default layout name, or null if none.
     *
     * @return string|null
     */
    public function getDefaultName();

    /**
     * Get all registered layouts as an associative array.
     *
     * @return array
     */
    public function all();
}
