<?php
namespace boru\dweb\Contracts;

/**
 * Resolves a layout selector string into a concrete (module, layoutId) pair.
 *
 * Rules (by design):
 * - If $layoutSelector contains "/", treat it as module-local template id.
 * - If it contains ":", treat it as a namespaced layout name (use LayoutRegistry).
 * - Otherwise, treat it as a logical name (e.g. "default") and resolve via
 *   LayoutRegistry's default name.
 */
interface LayoutResolverInterface
{
    /**
     * @param string $controllerModuleName The module that owns the view/template.
     * @param string $layoutSelector       e.g. "layouts/default", "default", "Skeleton:layout2"
     * @return array                       ['module' => string, 'layout' => string]
     */
    public function resolve($controllerModuleName, $layoutSelector);
}
