<?php
namespace boru\dweb\Contracts;

interface SessionInterface
{
    /**
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    public function get($key, $default = null);

    /**
     * @param string $key
     * @param mixed $value
     * @return void
     */
    public function set($key, $value);

    /**
     * @param string $key
     * @return void
     */
    public function remove($key);

    /**
     * @return array
     */
    public function all();

    /**
     * Regenerate the underlying session identifier.
     *
     * @param bool $deleteOld
     * @return void
     */
    public function regenerateId($deleteOld = true);
}
