<?php
namespace boru\dweb\Contracts;

interface SettingsInterface
{
    /**
     * Get a setting by key.
     *
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    public function get($key, $default = null);

    /**
     * Set a setting by key.
     *
     * @param string $key
     * @param mixed $value
     * @return $this
     */
    public function set($key, $value);

    /**
     * Get all settings as an associative array.
     *
     * @return array
     */
    public function all();

    /**
     * Get socket-related configuration as an associative array.
     *
     * @return array
     */
    public function socketConfig();
}