<?php
namespace boru\dweb\Contracts;

/**
 * Storage abstraction for opaque socket tokens.
 *
 * Implementations might use Redis, a database table, etc.
 */
interface SocketOpaqueTokenStoreInterface
{
    /**
     * Store token data with TTL.
     *
     * @param string $token
     * @param array  $data
     * @param int    $ttlSec
     * @return void
     */
    public function store($token, array $data, $ttlSec);

    /**
     * Fetch token data, or null if missing/expired.
     *
     * @param string $token
     * @return array|null
     */
    public function get($token);

    /**
     * Delete a token explicitly.
     *
     * @param string $token
     * @return void
     */
    public function delete($token);
}
