<?php
namespace boru\dweb\Debug;

use boru\dweb\Routing\RouteCollection;

class RouteDump
{
    public static function toArray(RouteCollection $routes)
    {
        $out = array(
            'views' => array(),
            'actions' => array(),
        );

        foreach ($routes->allViews() as $name => $handler) {
            $out['views'][] = array(
                'name' => (string)$name,
                'type' => 'view',
            );
        }

        foreach ($routes->allActions() as $name => $rec) {
            $methods = null;
            if (isset($rec['methods']) && is_array($rec['methods'])) {
                $methods = array_keys($rec['methods']);
                sort($methods);
            }

            $out['actions'][] = array(
                'name' => (string)$name,
                'type' => 'action',
                'methods' => $methods,
            );
        }

        // sort for stable output
        usort($out['views'], function($a, $b){ return strcmp($a['name'], $b['name']); });
        usort($out['actions'], function($a, $b){ return strcmp($a['name'], $b['name']); });

        return $out;
    }
}
