<?php
namespace boru\dweb\Exceptions;

use boru\dweb\Exceptions\ContextException;

class ContainerEntryNotFound extends ContextException
{
    public function __construct($id, array $knownIds = array())
    {
        parent::__construct(
            "Container entry not found: " . (string)$id,
            array(
                'id' => (string)$id,
                'known_count' => count($knownIds),
                // optional: don't dump everything if huge
                'known_sample' => array_slice($knownIds, 0, 25),
            )
        );
    }
}
