<?php
namespace boru\dweb\Kernel;

use boru\dweb\Contracts\SettingsInterface;
use boru\dweb\Contracts\RendererInterface;
use boru\dweb\Contracts\TemplateLocatorInterface;
use boru\dweb\Contracts\LoggerInterface;
use boru\dweb\Http\Request;
use boru\dweb\Routing\CanonicalUrl;

/**
 * Typed service accessors (DX helper).
 *
 * Philosophy:
 * - No container magic, no aliases, no strings at call sites.
 * - Pure sugar around $container->get(Foo::class).
 * - Centralizes "core services" in one IDE-autocomplete friendly place.
 *
 * PHP 5.6 compatible (no return types).
 */
class Services
{
    private function __construct() {}

    /** @return SettingsInterface */
    public static function settings(Container $c)
    {
        return $c->get(SettingsInterface::class);
    }

    /** @return LoggerInterface */
    public static function logger(Container $c)
    {
        return $c->get(LoggerInterface::class);
    }

    /** @return Request */
    public static function request(Container $c)
    {
        return $c->get(Request::class);
    }

    /** @return RendererInterface */
    public static function renderer(Container $c)
    {
        return $c->get(RendererInterface::class);
    }

    /** @return TemplateLocatorInterface */
    public static function templateLocator(Container $c)
    {
        return $c->get(TemplateLocatorInterface::class);
    }

    /** @return CanonicalUrl */
    public static function canonicalUrl(Container $c)
    {
        return $c->get(CanonicalUrl::class);
    }

    public static function socketTokenService(Container $c)
    {
        return $c->get(\boru\dweb\Support\SocketTokenService::class);
    }

    public static function socketOpaqueTokenStore(Container $c)
    {
        return $c->get(\boru\dweb\Contracts\SocketOpaqueTokenStoreInterface::class);
    }
}