<?php
namespace boru\dweb\Middleware;

use boru\dweb\Contracts\MiddlewareInterface;
use boru\dweb\Contracts\LoggerInterface;
use boru\dweb\Http\Request;
use boru\dweb\Http\HttpException;

class JsonBodyMiddleware implements MiddlewareInterface
{
    /** @var LoggerInterface|null */
    private $logger;

    public function __construct(LoggerInterface $logger = null)
    {
        $this->logger = $logger;
    }

    public function handle(Request $req, $next)
    {
        $ct = strtolower((string)$req->header('content-type', ''));
        if (strpos($ct, 'application/json') === false) {
            return $next($req);
        }

        $raw = (string)$req->rawBody();
        if ($raw === '') {
            return $next($req);
        }

        $data = json_decode($raw, true);
        if ($data === null && json_last_error() !== JSON_ERROR_NONE) {
            if ($this->logger) {
                $this->logger->warning('Invalid JSON body', array('error' => json_last_error_msg()));
            }

            throw new HttpException(
                400,
                'Bad Request',
                'Invalid JSON body.',
                json_last_error_msg()
            );
        }

        if (is_array($data)) {
            // Merge JSON keys into request query params so existing $req->param(...) works.
            $req = $req->withQueryParams($data);
        }

        return $next($req);
    }
}
